/**
 * liveValidator 0.1
 * Copyright (c) 2014 pqfang http://zuiyuexuan.sianapp.com/
 * Date: 2014-02-20
 * 使用liveValidator可以实时验证数据已满足的验证条件
 * TODO:由于时间紧张，目前定位需要手动配置，待有时间时改为插件自动配置
 */
(function($){
    $.fn.liveValidator = function (options) {
        var opts;
        var DATA_NAME = "liveValidator";
        //对象缓存
        var oData = $(this).data(DATA_NAME);
        var PLUGIN = $.fn.liveValidator;
        //返回API
        if (typeof options == 'string') {
            if (options == 'api') {
                //返回实例化的对象
                return oData;
            }
            else if (options == 'interfaces') {
                return oData.interfaces;
            }
        }
        else {
            var options = options || {};
            //覆盖参数
            opts = $.extend(true, {}, PLUGIN.defaults, options);
        }

        return $(this).each(function () {
            //调用方法
            if (typeof options == 'string') {

            }
            //创建
            else {
                //获取接口id
                var id = PLUGIN.interfaces.length;
                for (i = 0; i < id; i++) {
                    if (typeof PLUGIN.interfaces[i] == 'undefined') {
                        id = i;
                        break;
                    }

                }

                //实例化类
                var liveValidator = new Valid.liveValidator(opts);
                liveValidator.$input =$(this);
                liveValidator.render();
                //将对象存入interfaces数组内
                PLUGIN.interfaces[id] = liveValidator;
                //将实例化后对象写入缓存
                $(this).data(DATA_NAME, liveValidator);
            }
        })
    }

    var Valid = Valid || {};
    Valid.liveValidator =function(options){
        //参数
        this.options = options;
        //是否需要显示编号
        this.list = this.options.list;
        this.direction  = this.options.direction ;
        this.top  = this.options.top;
        this.left  = this.options.left;
        this.width  = this.options.width;
        this.arrow =this.options.arrow;
        //数据加载完后，回调函数
        this.complete = this.options.complete;

    }
    Valid.liveValidator.prototype = {
        /**
         * @description 运行构建验证函数
         * @public
         */
        render: function () {
            this._initValidDom();
        },
        /**
         * @description 初始化验证模板
         * @private
         */
        _initValidDom: function () {
            var thisDOM = this,
                initDOMId = 'test'+random_numbers(2),
                initDOMStr =[];

            thisDOM.$input.parent().css({"position":"relative","z-index":"1"});
            thisDOM.ID = initDOMId;
            var unit =thisDOM.left.indexOf("%")>-1 ? "": "px";
            initDOMStr.push('<div class="SD-tipbox" style="display: none;top:'+thisDOM.top+'px;left:'+thisDOM.left+unit+';width:'+thisDOM.width+'" id="'+initDOMId+'">');
            initDOMStr.push('<div class="pwd_tips">');

            $.each(thisDOM.list,function(i,o){
                var item_height = o["height"];
                if(o["height"]){
                    initDOMStr.push('<div class="default" style="height: '+item_height+'px;"><i></i>'+ o["info"]+'</div>');
                }else{
                    initDOMStr.push('<div class="default"><i></i>'+ o["info"]+'</div>');
                }
            });
            initDOMStr.push('</div>' +
                '<div class="SD-tipbox-direction SD-tipbox-'+thisDOM.direction+'" style="margin-top:'+thisDOM.arrow+'px">' +
                '<em>◆</em><span>◆</span>' +
                '</div></div>');
            thisDOM.$input.parent().append(initDOMStr.join(""));
            thisDOM._loadValiData();
            if (thisDOM.complete) {
                thisDOM.complete.call(thisDOM, thisDOM);
            }
        },
        /**
         *绑定事件
         * @private
         */
        _loadValiData: function(){
            var thisDOM = this;
            var $listDOM =$("#"+thisDOM.ID);
            thisDOM.$input.on("focus",function(){
                thisDOM._focusEvent($listDOM);
				//在获得焦点的瞬间检测密码是否符合标准，因为密码框中可能已经存在有值
				thisDOM._keyUpEvent($listDOM);
            });
            thisDOM.$input.on("keyup",function(){
                thisDOM._keyUpEvent($listDOM);
            });
            thisDOM.$input.on("blur",function(){
                thisDOM._blurEvent($listDOM);
            });
        },
        _focusEvent:function($listDOM){
            $listDOM.show();
        },
        _keyUpEvent:function($listDOM){
            var thisDOM = this;
            var input_Value = thisDOM.$input.val();
            //如果字符为空，回复默认显示状态
            if(input_Value==""){
                $listDOM.find(".pwd_tips").find("div").removeClass().addClass("default");
                return false;
            }
            $.each(thisDOM.list,function(i,o){
                var type = typeof o;
                if(type =="object"){
                    if(o.hasOwnProperty("reg")){
                        var reg = new RegExp(o["reg"]);
                        var result = reg.test(input_Value) ? "yes" : "no";
                        $listDOM.find(".pwd_tips").find("div").eq(i).removeClass().addClass(result);
                    }
                    if(o.hasOwnProperty("fun")){
                        var resultFun = o["fun"](input_Value) ? "yes" : "no";
                        $listDOM.find(".pwd_tips").find("div").eq(i).removeClass().addClass(resultFun);
                    }
                }
            });
        },
        _blurEvent:function($listDOM){
            if(!$listDOM.find(".pwd_tips div").hasClass("no")){
                $listDOM.hide();
            }
        }
    }
    //接口数组
    $.fn.liveValidator.interfaces = [];
    //默认参数
    $.fn.liveValidator.defaults = {
        direction: "left",
        list: [],
        left:"220",
        top:"-25",
        arrow:"-8",
        width:"auto"
    };
})(jQuery);

/**
 * 获取随机的n位随机数
 * @param n
 * @returns {string}
 */
function  random_numbers(n) {
    var rnd = "";
    for (var i = 0; i < n; i++)
        rnd += Math.floor(Math.random() * 10);
    return rnd;
}